
% Help generate Table 8.5 in the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 5/12/2008
%

clc
clear all
close all

%% get the FOUs from the IA; only return 9 words
[words,MFs,Cs]=getFOUsC8();

%% Construct the rulebase
subsetSurvey=[1 4 5 7 9]; %% indices of the five words used in the survey
antMFsSurvey=MFs(subsetSurvey,:);
CsSurvey=Cs(subsetSurvey); %% centers of centroid of the five words in the survey
names=['1. None to very little (NVL)'
    '        2. Some (S)         '
    '  3. Moderate amount (MOA)  '
    '    4. Large amount (LA)    '
    '   5. Maximum amount (MAA)  ']; %% names of the five words in the survey


%% for SJA1
histogram=[42 3 2 0 0
    33 12 0 2 0
    12 16 15 3 1
    3 6 11 25 2
    3 6 8 22 8]; %% survey histrogram

histogram1=zeros(size(histogram));
histogram2=zeros(size(histogram));
histogram3=zeros(size(histogram));

%% Pre-processing
for i=1:length(histogram)
    %% step 1
    left=find(histogram(i,:)>0,1,'first');
    right=find(histogram(i,:)>0,1,'last');
    zero=find(histogram(i,left:right)==0);
    k=length(zero);
    if k>0
        zero=[max(left-1,1) zero min(right+1,size(histogram,2))];
        for j=1:k+1
            temp(j)=sum(histogram(i,zero(j):zero(j+1)));
        end
        J=find(temp==max(temp));
        if mod(length(J),2)==1 %% J has an odd number of elements
            histogram1(i,zero(median(J)):zero(median(J)+1))=histogram(i,zero(median(J)):zero(median(J)+1));
        elseif length(J)>0 %% J has an even number of elements
            if sum(histogram1(i,1:zero(J/2+1)))>=sum(histogram1(i,zero(J/2+1):size(histogram,2)))
                histogram1(i,zero(J/2):zero(J/2+1))=histogram(i,zero(J/2):zero(J/2+1));
            else
                histogram1(i,zero(J/2+1):zero(J/2+2))=histogram(i,zero(J/2+1):zero(J/2+2));
            end
        end
    else
        histogram1(i,:)=histogram(i,:);
    end
    %% step 2
    I=find(histogram1(i,:)>0);
    temp2(1:histogram1(i,I(1)))=CsSurvey(I(1))*ones(1,histogram1(i,I(1)));
    for j=2:length(I)
        temp2(sum(histogram1(i,I(1:j-1)))+1:sum(histogram1(i,I(1:j))))=CsSurvey(I(j))*ones(1,histogram1(i,I(j)));
    end
    lengInputs=length(temp2);
    sortedInputs=sort(temp2);
    index25=lengInputs*.25;  %% 1st Quantile
    %% if index25 is an integer
    if mod(index25,1)==0
        Q25=sortedInputs(index25);
    else
        Q25=sortedInputs(floor(index25))*(ceil(index25)-index25)+...
            sortedInputs(ceil(index25))*(index25-floor(index25)); %% linear interpolation
    end

    index75=lengInputs*.75; %% 3rd quantile
    if mod(index75,1)==0
        Q75=sortedInputs(index75);
    else
        Q75=sortedInputs(floor(index75))*(ceil(index75)-index75)+...
            sortedInputs(ceil(index75))*(index75-floor(index75)); %% lnear interpolation
    end

    %% Box and Whisker Test
    IQR=Q75-Q25; %% inter-quantile range
    indexOutliers=[];
    for j=1:lengInputs
        if temp2(j)<Q25-1.5*IQR | temp2(j)>Q75+1.5*IQR
            indexOutliers=[indexOutliers j];
        end
    end
    histogram2(i,:)=histogram1(i,:);
    outliers=unique(temp2(indexOutliers));
    for j=1:length(outliers)
        histogram2(i,find(CsSurvey==outliers(j)))=0;
    end
    %% Step 3
    tempInputs=temp2;
    tempInputs(indexOutliers)=[];
    m=mean(tempInputs);
    sigma=std(tempInputs);
    k=findK(lengInputs,.95); %% find the parameter k
    lowerBound=m-k*sigma;
    upperBound=m+k*sigma;
    indexOutliers=[];
    for j=1:length(tempInputs)
        if tempInputs(j)<lowerBound | tempInputs(j)>upperBound
            index=find(temp2==tempInputs(j));
            indexOutliers=[indexOutliers index];
        end
    end

    histogram3(i,:)=histogram2(i,:);
    outliers=unique(temp2(indexOutliers));
    for j=1:length(outliers)
        histogram3(i,find(CsSurvey==outliers(j)))=0;
    end
end

histogram-histogram1
histogram1-histogram2
histogram2-histogram3

